using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.Odbc;
using Microsoft.Reporting.WinForms;

namespace OurWinDemo
{
    public partial class Form1 : Form
    {
        String SSRSFilePath = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

            this.reportViewer1.RefreshReport();
        }

        private DataTable getData()
        {
            String connectString = dbConnectionString.Text;

            OdbcConnection conn = new OdbcConnection(connectString);
            conn.Open();

            DataSet dss = new DataSet();
            string sql = "";

            sql = sqlQueryText.Text;
            OdbcDataAdapter da = new OdbcDataAdapter(sql, conn);
            da.Fill(dss);
            DataTable dt = dss.Tables[0];
            return dt;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.reportViewer1.Reset();

            this.reportViewer1.LocalReport.ReportPath = reportPath.Text;

            this.reportViewer1.LocalReport.EnableExternalImages = true;
            this.reportViewer1.LocalReport.EnableHyperlinks = true;

            ReportDataSource rds = new ReportDataSource("DataSet1", getData());
            this.reportViewer1.LocalReport.DataSources.Clear();
            this.reportViewer1.LocalReport.DataSources.Add(rds);

            this.reportViewer1.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(SetSubDataSource);

            // The application is responsible for collecting parameters
            // ReportParameterInfoCollection parameterInfo = reportViewer1.LocalReport.GetParameters();
            //if (parameterInfo.Count > 0)
            //{
                //handle paremeters in the report;
            //}

            this.reportViewer1.RefreshReport();
        }

        private void label1_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(reportPath.Text) || String.IsNullOrEmpty(reportPath.Text))
            {
                button1.Enabled = false;
            }

            button1.Enabled = true;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "rdlc (*.rdlc)|*.rdlc|Microsoft SSRS (*.rdl)|*.rdl";
            openFileDialog1.FilterIndex = 2;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                String rdlFullPath = openFileDialog1.FileName;

                reportPath.Text = rdlFullPath;

                SSRSFilePath = rdlFullPath.Substring(0, rdlFullPath.LastIndexOf("\\") + 1);

                // Get DB connection
                dbConnectionString.Text = getTagContent(openFileDialog1.FileName, "<ConnectString>", "</ConnectString>");

                // Get SQL query
                sqlQueryText.Text = getTagContent(openFileDialog1.FileName, "<CommandText>", "</CommandText>");
            }
        }

        internal String getTagContent(String fileName, String startTagName, String endTagName)
        {
            String contentString = "";

            System.IO.FileInfo fileInfo = new System.IO.FileInfo(fileName);

            // The buffer size is set to 10kb
            int buffLength = 10240;
            byte[] buff = new byte[buffLength];

            // Opens a file stream (System.IO.FileStream) to read the file to be uploaded
            System.IO.FileStream fileStream = fileInfo.OpenRead();

            try
            {
                // Read from the file stream 2kb at a time
                int contentLen = fileStream.Read(buff, 0, buffLength);

                if (contentLen != 0)
                {
                    String fileBuffer = Encoding.UTF8.GetString(buff);

                    int tagStart = fileBuffer.IndexOf(startTagName);
                    int tagEnd = fileBuffer.IndexOf(endTagName);

                    if (tagStart != -1 && tagEnd != -1)
                    {
                        contentString = fileBuffer.Substring(tagStart + startTagName.Length, tagEnd - tagStart - startTagName.Length);
                    }
                }

                fileStream.Close();
            }
            catch (Exception ex)
            {
            }

            return contentString;
        }

        public void SetSubDataSource(object sender, SubreportProcessingEventArgs e)
        {
            String connectString = dbConnectionString.Text;

            OdbcConnection conn = new OdbcConnection(connectString);
            conn.Open();

            DataSet dss = new DataSet();

            String subreportPath = SSRSFilePath + e.ReportPath + ".rdlc";

            String sql = getTagContent(subreportPath, "<CommandText>", "</CommandText>");

            OdbcDataAdapter da = new OdbcDataAdapter(sql, conn);
            da.Fill(dss);
            DataTable dt = dss.Tables[0];

            ReportDataSource rds = new ReportDataSource("DataSet1", dt);

            e.DataSources.Add(rds);
        }
    }
}